<?php
/* --------------------------------------------------------------
 BootableLeagueServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class BootableLeagueServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
class BootableLeagueServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var AbstractBootableServiceProvider
     */
    private $adapter;
    
    
    /**
     * BootableLeagueServiceProvider constructor.
     *
     * @param AbstractBootableServiceProvider $adapter
     */
    public function __construct(AbstractBootableServiceProvider $adapter)
    {
        $this->adapter  = $adapter;
        $this->provides = $adapter->provides();
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        $this->adapter->boot();
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->adapter->register();
    }
    
    
    /**
     * Overrides the identifier accessor.
     * Instead of using the class name as fallback identifier, we will use the name of the adapters class.
     *
     * @return string
     */
    public function getIdentifier(): string
    {
        return $this->identifier ?? get_class($this->adapter);
    }
}